package examples.localserver;

import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 * Запрос на подписания данных XML в формате XMLDsig
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DocumentXmlSignatureRequest")
public class DocumentXmlSignatureRequest {

    @XmlElement(required = true)
    @Documentation("xml-представление документа для подписания")
    private String signableXmlData;

    @XmlElement(required = true)
    @Documentation("Путь к сертификату на локальном компьютере")
    private String certificatePath;

    @XmlElement(required = true)
    @Documentation("Пароль к контейнеру с сертификатом")
    private String certificatePin;

    public String getSignableXmlData() {
        return signableXmlData;
    }

    public void setSignableXmlData(String signableXmlData) {
        this.signableXmlData = signableXmlData;
    }

    public String getCertificatePath() {
        return certificatePath;
    }

    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    public String getCertificatePin() {
        return certificatePin;
    }

    public void setCertificatePin(String certificatePin) {
        this.certificatePin = certificatePin;
    }

}
